# Granular Healing

## Python module associated to the 2022 GeoMod material benchmark.

Estimates the amount of healing from a series of slide-hold-slide tests done with a Schulze RST01.pc ring shear tester.

## Installation instructions

Navigate to the main folder `granular-healing` and run `python3 -m pip install .` this will install the package and all necessary additional modules.
Alternatively you can run to get the software directly from the repository:
```
python -m pip install git+https://git.gfz-potsdam.de/analab-code/granular-healing.git
```
To run the script run:
```
python -m granularhealing
```

## Requirements

A Python 3 installation is required. The software was only tested for 'pip', however 'conda' installations might also work. The software will additionally load these packages from the internet: `animation, matplotlib, npTDMS, numpy, pathvalidate, scipy, setuptools, tqdm, uncertainties`. These might load additional libraries.

## Usage for Single-File SHS tests

The main software is designed for multi-file SHS tests. However in 'scripts' there is a single file version. This will open a simple plot that shows the velocity curve vs. index. In the command prompt you will be asked to input first the start and end of stable sliding for the first slide phase which is taken as a reference for the stable sliding friction. Then you have to pick the start and end of the re-loading phases. For this you have to enter the index (x-value in plot) shortly before and after the reslide for each slide phase.


## Citation

Please cite this repository as:

Rudolf, Michael (2023): Granular Healing - Python module associated to the 2022 GeoMod material benchmark. GFZ Data Services, https://doi.org/10.5880/fidgeo.2023.010.