#!/usr/bin/env python3
# This file is part of granularhealing.

# granularhealing is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# granularhealing is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with granularhealing. If not, see <https://www.gnu.org/licenses/>.

"""
Creates all plots for the publication on granular healing
"""


import os

import granularhealing.figures as ghfigures
import granularhealing.files as ghfiles

SAVEINTERMEDS = False


def main():
    """Main function for creating all plots"""
    base_folder = ghfiles.ask_for_folder()
    if not base_folder:
        return None

    os.makedirs(os.path.join(base_folder, "Output"), exist_ok=True)

    print("Creating Timeseries for Figure 1")
    ghfigures.figure1_shs_timeseries(base_folder)
    print("Creating top plot for Figure 3 - qualiscore")
    ghfigures.figure3_grain_char(base_folder)
    print("Creating Figure 4 and 5 - healing rates and compaction rates")
    ghfigures.figure4_5_healing_rates(base_folder)
    print("Creating plot for Figure 6 - forces")
    ghfigures.figure6_forces(base_folder)
    print("Creating plot for Figure 6 - reactivation angles")
    ghfigures.figure6_angles(base_folder)
    print("Creating Figure 7 - qualiscore_friction")
    ghfigures.figure7_qualiscore_friction(base_folder)


if __name__ == "__main__":
    main()
