#!/usr/bin/env python3
# This file is part of granularhealing.

# granularhealing is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# granularhealing is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with granularhealing. If not, see <https://www.gnu.org/licenses/>.
import granularhealing.groups as ghgroups
import numpy as np


def main():
    masses = {
        "quartz sand": [],
        "corundum sand": [],
        "feldspar sand": [],
        "garnet sand": [],
        "glass beads": [],
        "zircon sand": [],
        "foam glass": [],
    }
    group_dict = ghgroups.get_group_dict()
    for mat, val in group_dict["mass"].items():
        masses[group_dict["mats"][group_dict["mat_group"][mat]]].append(
            val - 2185.5
        )
    for mat, val in masses.items():
        # avg = unc.ufloat(np.mean(val), 2 * np.std(val))
        err = 2 * np.std(val)
        if err < 70:
            err = 70
        print(mat, ": unc.ufloat(%i, %i)," % (np.mean(val), err))


if __name__ == "__main__":
    main()
