import matplotlib.pyplot as plt
import numpy as np


def main():
    b = np.linspace(0, 0.1, 100)
    crit_stiff = kc(zeta(b))

    fig, ax = plt.subplots()
    ax.plot(b, crit_stiff)
    plt.show()


def zeta(b, a=0.005, mu_ss=0.6, alpha=0.3, phi=0):
    return (b - a) / (1 + (mu_ss - alpha) * np.tan(phi))


def kc(zeta, sigma=1000, dc=150):
    return (zeta * sigma) / dc


if __name__ == "__main__":
    main()
