# Py4HIP
**Py4HIP**: **Py**thon tool **for** **H**eat-**I**n-**P**lace calculations

## Contents
[TOC]

## Description
**Py4HIP** is implemented as a self-explanatory [Jupyter notebook](https://jupyter-notebook-beginner-guide.readthedocs.io/en/latest/what_is_jupyter.html) [Py4HIP.ipynb](./Py4HIP.ipynb).

Calculation of the Heat In Place (HIP) for certain geological units or confined reservoirs is a standard method performed in various regions to assess the spatial variability of geothermal potential ([Nathenson, 1975](#Nathenson1975); [Muffler and Cataldi, 1978](#MufflerCataldi1978); [Garg and Combs, 2015](#GargCombs2015)).

The respective implementation in **Py4HIP** is based on a volumetric quantification of contained energy after [Muffler and Cataldi (1978)](#MufflerCataldi1978), where the geological unit at hand is considered as spatially variable in terms of its thickness, porosity, as well as density and specific heat capacity. **Py4HIP** calculations take into account the pore fluid density and the salinity effect.
The energy values provided by **Py4HIP** as ASCII lists and map representations correspond to the stored energy in $J/m^2$.

## Getting started

### Requirements
**Py4HIP** requires [Python](https://www.python.org/) >= 3.5, [JupyterLab](https://jupyterlab.readthedocs.io/en/stable/), and uses the following packages:
- [numpy](https://github.com/numpy/numpy)
- [pandas](https://github.com/pandas-dev/pandas)
- [pathlib](https://docs.python.org/3/library/pathlib.html) (for creating folders)
- [matplotlib](https://github.com/matplotlib/matplotlib) (for plotting figures)

### Installation
The following instructions explain how to install the required packages with [`conda`](https://docs.conda.io/en/latest/).

We recommend to use [miniforge](https://github.com/conda-forge/miniforge) for working with conda.

1. To install the required packages open conda prompt and run:
```
conda install -y numpy pandas pathlib matplotlib
```

**Note:** you may want to use a specific [conda environment](https://conda.io/projects/conda/en/latest/user-guide/tasks/manage-environments.html).

2. Install the JupyterLab:
```
conda install -y jupyterlab
```

3. Get the tool by cloning the git repository using [Git](https://git-scm.com/):
```bash
git clone git@git.gfz-potsdam.de:basin-modelling/python/py4hip.git
```
or
```bash
git clone https://git.gfz-potsdam.de/basin-modelling/python/py4hip.git
```
Alternatively, load the package as [zip file](https://git.gfz-potsdam.de/basin-modelling/python/py4hip/-/archive/main/py4hip-main.zip).

### How to run
1. Open conda prompt and start JupyterLab using:
```
jupyter lab
```
You may access JupyterLab by opening the notebook server’s URL in the browser, usually `http://localhost:8888/lab` wihch you can find in the output, e.g.
```
To access the server, open this file in a browser:
     <link>
 Or copy and paste one of these URLs:
     <link>
  or <link>
```

It often necessary to insert the token generated after server has started.
You can find this in the command output after `token=`, e.g.:
```
http://localhost:8888/lab?token=73e08328facee92d67a8dd2b587b6fa7cb8a3e3323d653f8
```
2. In the JupyterLab interface open [Py4HIP.ipynb](./Py4HIP.ipynb)

3. Read the instructions and run

## License
**Py4HIP** is [licensed](./LICENSE) under the [EUROPEAN UNION PUBLIC LICENCE (EUPL) v. 1.2](https://joinup.ec.europa.eu/collection/eupl/introduction-eupl-licence).

## Citation
Please cite **Py4HIP** as follows:\
*Bott, J., Benoit, L., Koltzer, N., Anikiev, D. (2022): Py4HIP: Python tool for Heat-In-Place calculations. V. 1. GFZ Data Services, https://doi.org/10.5880/GFZ.4.5.2022.001*

Citation bib file: [CITATION.bib](./CITATION.bib)

## Authors and contributions
See also the list of [authors](../AUTHORS.md) who participated in this project.
If you what to contribute to this project please follow the [contributing guidelines](../CONTRIBUTING.md).

## Acknowledgments
We are grateful to all colleagues who supported the project.

## References
<a name='Baer2012'></a>
Bär, K. M. (2012). Untersuchung der tiefengeothermischen Potenziale von Hessen. (Ph.D. Thesis). TU Darmstadt, Darmstadt. https://tuprints.ulb.tu-darmstadt.de/3067/

<a name='BatzleWang1992'></a>
Batzle, M., & Wang, Z. (1992). Seismic properties of pore fluids. Geophysics, 57(11), 1396-1408. https://www.doi.org/10.1190/1.1443207

<a name='GargCombs2015'></a>
Garg, S. K., & Combs, J. (2015). A reformulation of USGS volumetric “heat in place” resource estimation method. Geothermics, 55, 150-158.
https://www.doi.org/10.1016/j.geothermics.2015.02.004

<a name='MufflerCataldi1978'></a>
Muffler, P., & Cataldi, R. (1978). Methods for regional assessment of geothermal resources. Geothermics, 7(2-4), 53-89.
https://www.doi.org/10.1016/0375-6505(78)90002-0

<a name='Nathenson1975'></a>
Nathenson, M. (1975). Physical factors determining the fraction of stored energy recoverable from hydrothermal convection systems and conduction-dominated areas (No. USGS-OFR-75-525). Geological Survey, Menlo Park, Calif.(USA). https://www.doi.org/10.2172/7348122

<a name='VosteenSchellschmidt2003'></a>
Vosteen, H.-D., & Schellschmidt, R. (2003). Influence of temperature on thermal conductivity, thermal capacity and thermal diffusivity for different types of rock. Physics and Chemistry of the Earth, Parts A/B/C, 28(9-11), 499-509.
https://doi.org/10.1016/S1474-7065(03)00069-X

References are available as [a bib file](./references.bib).

## Contact
[Judith Bott](@sippel): judith.bott@gfz-potsdam.de
