[Mesh]
  [original_mesh]
    type = FileMeshGenerator
    file = mesh/brb_refine_x4_all.e
  []
  [rename_boundary]
    type = RenameBoundaryGenerator
    input = original_mesh
    old_boundary = '1 2'
    new_boundary = 'top bottom'
  []

  [add_rivers]
    type = GolemExtraNodesetGeneratorNN
    input = 'rename_boundary'
    file_name = 'tops/mesh_top_river_region.txt'
    dimension = 3
    exact_hit = false
    tolerance = 1e1
    new_boundary = 'top_river'

  []
[]

[Variables]
  [pore_pressure]
    [InitialCondition]
      type = FunctionIC
      function = pressure_gradient
    []
  []
[]

[GlobalParams]
  fluid_density_initial = 1000
  fluid_viscosity_initial = 1e-3
  #fluid_modulus = 2.18e+9
  gravity_acceleration = 9.80665
  porosity_uo = porosity
  scaling_uo = scaling
  permeability_uo = permeability
  fluid_density_uo = fluid_density
  fluid_viscosity_uo = fluid_viscosity
[]

[Functions]
  [pressure_gradient]
    type = ParsedFunction
    value = 'rho*g*(z-z0)+p0'
    vars = 'rho g z0 p0'
    vals = '1e-3 -9.8 328 0.1'
  []
  [func_upbc_steady]
    type = GolemFunctionSpace
    file_name = BC/P_golem_1999_DEM.csv
    dimension = 2
  []

[]

[BCs]
  [upbc]
    type = FunctionDirichletBC
    function = func_upbc_steady
    boundary = 'top'
    variable = pore_pressure
  []
  # [upbc]
  #   type = GolemSourceSinkBC
  #   bc_type = source
  #   source_sink_function=0.01
  #   boundary = 'top'
  #   variable = pore_pressure
  # []
  [urbc]
    type = DirichletBC
    value = 0.1
    boundary = 'top_river'
    variable = pore_pressure

  []

[]
[Kernels]
  [darcy]
    type = GolemKernelH
    variable = pore_pressure
  []
[]
[Materials]
  [01_quaternary]
    type = GolemMaterialH
    block = '0'
    porosity_initial = 0.23
    permeability_type = orthotropic
    permeability_initial = '1e-13 1e-13 1e-14'
  []
  [02_postrupelian]
    type = GolemMaterialH
    block = '1'
    porosity_initial = 0.23
    permeability_type = orthotropic
    permeability_uo = perm_postrupelian

  []
  [03_Rupelian]
    type = GolemMaterialH
    block = '2'
    porosity_initial = 0.20
    permeability_type = orthotropic
    permeability_uo = perm_rupelian

  []
  [04_Prerupelian]
    type = GolemMaterialH
    block = '3'
    porosity_initial = 0.1
    permeability_type = orthotropic
    permeability_initial = '1e-14 1e-14 1e-15'

  []
  [05_uppercretaceous]
    type = GolemMaterialH
    block = '4'
    porosity_initial = 0.1
    permeability_type = orthotropic
    permeability_initial = '1e-13 1e-13 1e-14'

  []
  [06_lowercretaceous]
    type = GolemMaterialH
    block = '5'
    porosity_initial = 0.13
    permeability_type = orthotropic
    permeability_initial = '1e-13 1e-13 1e-14'

  []
  [07_jurassic]
    type = GolemMaterialH
    block = '6'
    porosity_initial = 0.13
    permeability_type = orthotropic
    permeability_initial = '1e-13 1e-13 1e-14'

  []
  [08_Keuper]
    type = GolemMaterialH
    block = '7'
    porosity_initial = 0.06
    permeability_type = orthotropic
    permeability_initial = '1e-14 1e-14 1e-15'

  []
  [09_Muschelkalk]
    type = GolemMaterialH
    block = '8'
    porosity_initial = 0.001
    permeability_type = orthotropic
    permeability_initial = '1e-18 1e-18 1e-19'

  []
  [10_Buntsandstein]
    type = GolemMaterialH
    block = '9'
    porosity_initial = 0.04
    permeability_type = orthotropic
    permeability_initial = '1e-14 1e-14 1e-15'

  []
  [11_Zechstein]
    type = GolemMaterialH
    block = '10'
    porosity_initial = 1e-5
    permeability_type = orthotropic
    permeability_initial = '1e-17 1e-17 1e-18'

  []
  [12_basement]
    type = GolemMaterialH
    block = '11'
    porosity_initial = 1e-5

    permeability_initial = '1e-17'

  []

[]

[UserObjects]
  [scaling]
    type = GolemScaling
    characteristic_time = 31536000 #years
    characteristic_stress = 1e6
    execute_on = 'INITIAL'
  []
  [porosity]
    type = GolemPorosityConstant
    execute_on = 'INITIAL'
  []
  [fluid_density]
    type = GolemFluidDensityConstant
    execute_on = 'INITIAL'
  []
  [fluid_viscosity]
    type = GolemFluidViscosityConstant
    execute_on = 'INITIAL'
  []
  [permeability]
    type = GolemPermeabilityConstant
    execute_on = 'INITIAL'
  []

  [perm_postrupelian]
    type = GolemPermeabilityInterpolation
    dimension = 3
    tensor_type = orthotropic
    sample_file_name = 'prop/postrupelian_permeability.csv'
    interpolation_type = max_neighbours
    patch_size = 4
    max_leaf = 10
    epsilon = 1e-10
    execute_on = 'INITIAL'
  []
  [perm_rupelian]
    type = GolemPermeabilityInterpolation
    dimension = 3
    tensor_type = orthotropic
    sample_file_name = 'prop/rupelian_permeability.csv'
    interpolation_type = max_neighbours
    patch_size = 4
    max_leaf = 10
    epsilon = 1e-10
    execute_on = 'INITIAL'
  []
[]

[Preconditioning]
  active = 'hypre'
  [hypre]
    type = SMP
    full = true
    petsc_options = '-snes_ksp_ew -snes_converged_reason -snes_monitor' #-snes_monitor -snes_linesearch_monitor -snes_converged_reason -ksp_converged_reason -ksp_monitor_short'
    petsc_options_iname = '-snes_force_iteration
                          -snes_linesearch_type
                          -snes_atol -snes_rtol -snes_max_it
                          -ksp_type
                          -ksp_rtol -ksp_max_it -ksp_gmres_restart
                          -pc_type -pc_hypre_type '
    petsc_options_value = '1
                          basic
                          1e-3 1e-14 500
                          fgmres 1e-8 500 201
                          hypre boomeramg'
  []
  [asm]
    type = SMP
    full = true
    petsc_options = '-snes_ksp_ew' #-snes_monitor -snes_linesearch_monitor -snes_converged_reason -ksp_converged_reason -ksp_monitor_short'
    petsc_options_iname = '-snes_type -snes_linesearch_type
                          -snes_atol -snes_rtol -snes_max_it
  						            -ksp_type -ksp_rtol -ksp_max_it
                          -pc_type -pc_asm_overlap
                          -sub_pc_type
                          -sub_pc_factor_levels -sub_pc_shift_type -sub_pc_shift_amount'
    petsc_options_value = 'newtonls basic
                          1e-3 1e-16 100
						              fgmres 1e-8 500
						              asm 3
                          ilu 1 NONZERO 1e-10'
  []
[]


[Executioner]
  type = Steady
  solve_type = NEWTON
  automatic_scaling = true
  compute_scaling_once = false
[]

[Outputs]
  print_linear_residuals = false
  perf_graph = true


[]

[Debug]
  # show_var_residual = 'pore_pressure temperature'
  show_var_residual_norms = true
[]
