[Mesh]
  [original_mesh]
    type = FileMeshGenerator
    file = mesh/brb_refine_x4_all.e
  []
  [rename_boundary]
    type = RenameBoundaryGenerator
    input = original_mesh
    old_boundary = '1 2'
    new_boundary = 'top bottom'
  []
[]

[Variables]
  [temperature]
    [InitialCondition]
      type = FunctionIC
      function = t_gradient
    []
  []
[]

[GlobalParams]
  # global UOs
  scaling_uo = scaling
  porosity_uo = porosity
  fluid_thermal_conductivity_uo = lambda_f
[]

[Functions]
  [t_gradient]
    type = ParsedFunction
    value = 'grad*(z-z0)+T0'
    vars = 'grad z0 T0'
    vals = '-0.03 328 10'
  []
  [func_ltbc_steady]
    type = GolemFunctionSpace
    file_name = BC/temp_z6000_brb_modwrupel.csv
    dimension = 2
  []
  [func_utbc_steady]
    type = GolemFunctionSpace
    file_name = BC/steady_tavg1951-1953.csv
    dimension = 2
  []
[]

[BCs]
  [utbc]
    type = FunctionDirichletBC
    function = func_utbc_steady
    boundary = 'top'
    variable = temperature
  []
  [ltbc]
    type = FunctionDirichletBC
    function = func_ltbc_steady
    boundary = 'bottom'
    variable = temperature
  []
[]

[Kernels]
  [T]
    type = GolemKernelT
    variable = temperature
  []
[]

[Materials]
  [01_quaternary]
    type = GolemMaterialT
    block = '0'
    porosity_initial = 0.23
    solid_thermal_conductivity_uo = lambda_quaternary
    solid_heat_rate_uo = radio_quaternary
  []
  [02_postrupelian]
    type = GolemMaterialT
    block = '1'
    porosity_initial = 0.23
    solid_thermal_conductivity_uo = lambda_postrupelian
    solid_heat_rate_uo = radio_postrupelian
  []
  [03_Rupelian]
    type = GolemMaterialT
    block = '2'
    porosity_initial = 0.20
    solid_thermal_conductivity_uo = lambda_rupelian
    solid_heat_rate_uo = radio_rupelian
  []
  [04_Prerupelian]
    type = GolemMaterialT
    block = '3'
    porosity_initial = 0.1
    solid_thermal_conductivity_uo = lambda_prerupelian
    solid_heat_rate_uo = radio_prerupelian
  []
  [05_uppercretaceous]
    type = GolemMaterialT
    block = '4'
    porosity_initial = 0.1
    solid_thermal_conductivity_uo = lambda_uppercretaceous
    solid_heat_rate_uo = radio_uppercretaceous
  []
  [06_lowercretaceous]
    type = GolemMaterialT
    block = '5'
    porosity_initial = 0.13
    solid_thermal_conductivity_uo = lambda_lowercretaceous
    solid_heat_rate_uo = radio_lowercretaceous
  []
  [07_jurassic]
    type = GolemMaterialT
    block = '6'
    porosity_initial = 0.13
    solid_thermal_conductivity_uo = lambda_jurassic
    solid_heat_rate_uo = radio_jurassic
  []
  [08_Keuper]
    type = GolemMaterialT
    block = '7'
    porosity_initial = 0.06
    solid_thermal_conductivity_uo = lambda_keuper
    solid_heat_rate_uo = radio_keuper
  []
  [09_Muschelkalk]
    type = GolemMaterialT
    block = '8'
    porosity_initial = 0.001
    solid_thermal_conductivity_uo = lambda_muschelkalk
    solid_heat_rate_uo = radio_muschelkalk
  []
  [10_Buntsandstein]
    type = GolemMaterialT
    block = '9'
    porosity_initial = 0.04
    solid_thermal_conductivity_uo = lambda_buntsandstein
    solid_heat_rate_uo = radio_buntsandstein
  []
  [11_Zechstein]
    type = GolemMaterialT
    block = '10'
    porosity_initial = 1e-5
    solid_thermal_conductivity_uo = lambda_zechstein
    solid_heat_rate_uo = radio_zechstein
  []
  [12_basement]
    type = GolemMaterialT
    block = '11'
    porosity_initial = 1e-5
    solid_thermal_conductivity_uo = lambda_basement
    solid_heat_rate_uo = radio_basement
  []

[]

[UserObjects]
  [scaling]
    type = GolemScaling
    characteristic_time = 31536000 #years
    characteristic_stress = 1e6
    execute_on = 'INITIAL'
  []
  [porosity]
    type = GolemPorosityConstant
    execute_on = 'INITIAL'
  []
  [lambda_f]
    type = GolemFluidThermalConductivityConstant
    value = 0.65
    execute_on = 'INITIAL'
  []
  [lambda_quaternary]
    type = GolemSolidThermalConductivityConstant
    value = 1.5
    execute_on = 'INITIAL'
  []
  [lambda_postrupelian]
    type = GolemSolidThermalConductivityConstant
    value = 1.5
    execute_on = 'INITIAL'
  []
  [lambda_rupelian]
    type = GolemSolidThermalConductivityConstant
    value = 1
    execute_on = 'INITIAL'
  []
  [lambda_prerupelian]
    type = GolemSolidThermalConductivityConstant
    value = 1.9
    execute_on = 'INITIAL'
  []
  [lambda_uppercretaceous]
    type = GolemSolidThermalConductivityConstant
    value = 1.9
    execute_on = 'INITIAL'
  []
  [lambda_lowercretaceous]
    type = GolemSolidThermalConductivityConstant
    value = 2
    execute_on = 'INITIAL'
  []
  [lambda_jurassic]
    type = GolemSolidThermalConductivityConstant
    value = 2
    execute_on = 'INITIAL'
  []
  [lambda_keuper]
    type = GolemSolidThermalConductivityConstant
    value = 2.3
    execute_on = 'INITIAL'
  []
  [lambda_muschelkalk]
    type = GolemSolidThermalConductivityConstant
    value = 1.85
    execute_on = 'INITIAL'
  []
  [lambda_buntsandstein]
    type = GolemSolidThermalConductivityConstant
    value = 2
    execute_on = 'INITIAL'
  []
  [lambda_zechstein]
    type = GolemSolidThermalConductivityConstant
    value = 3.5
    execute_on = 'INITIAL'
  []
  [lambda_basement]
    type = GolemSolidThermalConductivityConstant
    value = 2.5
    execute_on = 'INITIAL'
  []

  [radio_quaternary]
    type = GolemSolidHeatRateConstant
    value = 7e-7
    execute_on = 'INITIAL'
  []
  [radio_postrupelian]
    type = GolemSolidHeatRateConstant
    value = 7e-7
    execute_on = 'INITIAL'
  []
  [radio_rupelian]
    type = GolemSolidHeatRateConstant
    value = 4.5e-7
    execute_on = 'INITIAL'
  []
  [radio_prerupelian]
    type = GolemSolidHeatRateConstant
    value = 3e-7
    execute_on = 'INITIAL'
  []
  [radio_uppercretaceous]
    type = GolemSolidHeatRateConstant
    value = 3e-7
    execute_on = 'INITIAL'
  []
  [radio_lowercretaceous]
    type = GolemSolidHeatRateConstant
    value = 1.4e-6
    execute_on = 'INITIAL'
  []
  [radio_jurassic]
    type = GolemSolidHeatRateConstant
    value = 1.4e-6
    execute_on = 'INITIAL'
  []
  [radio_keuper]
    type = GolemSolidHeatRateConstant
    value = 1.4e-6
    execute_on = 'INITIAL'
  []
  [radio_muschelkalk]
    type = GolemSolidHeatRateConstant
    value = 3e-7
    execute_on = 'INITIAL'
  []
  [radio_buntsandstein]
    type = GolemSolidHeatRateConstant
    value = 1e-6
    execute_on = 'INITIAL'
  []
  [radio_zechstein]
    type = GolemSolidHeatRateConstant
    value = 9e-8
    execute_on = 'INITIAL'
  []
  [radio_basement]
    type = GolemSolidHeatRateConstant
    value = 1.5e-6
    execute_on = 'INITIAL'
  []

[]

[Preconditioning]
  [hypre]
    type = SMP
    full = true
    petsc_options = '-snes_ksp_ew -snes_converged_reason -snes_monitor' #-snes_monitor -snes_linesearch_monitor -snes_converged_reason -ksp_converged_reason -ksp_monitor_short'
    petsc_options_iname = '-snes_force_iteration
                          -snes_linesearch_type
                          -snes_atol -snes_rtol -snes_max_it
                          -ksp_type
                          -ksp_rtol -ksp_max_it -ksp_gmres_restart
                          -pc_type -pc_hypre_type '
    petsc_options_value = '1
                          basic
                          1e-3 1e-10 500
                          fgmres 1e-10 500 201
                          hypre boomeramg'
  []
[]

[Executioner]
  type = Steady
  solve_type = 'NEWTON'
  automatic_scaling = true
  compute_scaling_once = false
[]

[Outputs]
  print_linear_residuals = false
  perf_graph = true
[]

[Debug]
  show_var_residual_norms = true
[]
