[Mesh]
  [original_mesh]
    type = FileMeshGenerator
    file = mesh/brb_refine_x4_all.e
  []

  [rename_boundary]
    type = RenameBoundaryGenerator
    input = original_mesh
    old_boundary = '1 2'
    new_boundary = 'top bottom'
  []

  [add_rivers]
    type = GolemExtraNodesetGeneratorNN
    input = 'rename_boundary'
    file_name = 'tops/mesh_top_river_region.txt'
    dimension = 3
    exact_hit = false
    tolerance = 1e1
    new_boundary = 'top_river'

  []
[]

[Variables]
  [temperature]
  []
  [pore_pressure]
  []
[]

[GlobalParams]
  temperature = temperature
  pore_pressure = pore_pressure
  fluid_density_initial = 1000
  fluid_viscosity_initial = 1e-3
  fluid_modulus = 2.18e+9
  gravity_acceleration = 9.80665
  supg_uo = supg
  porosity_uo = porosity
  scaling_uo = scaling
  permeability_uo = permeability
  fluid_density_uo = fluid_density
  fluid_viscosity_uo = fluid_viscosity
  fluid_thermal_conductivity_uo = lambda_f
  fluid_heat_capacity_uo = cp_f
[]

[Kernels]
  [darcy]
    type = GolemKernelH
    variable = pore_pressure
  []
  [time_H]
    type = GolemKernelTimeH
    variable = pore_pressure
  []
  [T_dif]
    type = GolemKernelT
    variable = temperature
  []
  [time_T]
    type = GolemKernelTimeTSUPG
    variable = temperature
  []
  [T_adv]
    type = GolemKernelTHSUPG
    variable = temperature
    block = '0 1 2 3 4 5 6 7 8 9'
  []
[]

[Functions]
  [func_ltbc_steady]
    type = GolemFunctionSpace
    file_name = BC/temp_z6000_brb_modwrupel.csv
    dimension = 2
  []
  [func_utbc_steady]
    type = GolemFunctionSpace
    file_name = BC/steady_tavg1951-1953.csv
    dimension = 2
  []
  [func_upbc_steady]
    type = GolemFunctionSpace
    file_name = BC/P_golem_1999_DEM.csv
    dimension = 2
  []

[]

[BCs]
  [utbc]
    type = FunctionDirichletBC
    function = func_utbc_steady
    boundary = 'top'
    variable = temperature
  []
  [upbc]
    type = FunctionDirichletBC
    function = func_upbc_steady
    boundary = 'top'
    variable = pore_pressure
  []
  # [upbc]
  #   type = GolemSourceSinkBC
  #   bc_type = source
  #   source_sink_function=0.01
  #   boundary = 'top'
  #   variable = pore_pressure
  # []

  [urbc]
    type = DirichletBC
    value = 0.1
    boundary = 'top_river'
    variable = pore_pressure

  []

  [ltbc]
    type = FunctionDirichletBC
    function = func_ltbc_steady
    boundary = 'bottom'
    variable = temperature
  []
[]

[AuxVariables]
  [v_x]
    order = CONSTANT
    family = MONOMIAL
  []
  [v_y]
    order = CONSTANT
    family = MONOMIAL
  []
  [v_z]
    order = CONSTANT
    family = MONOMIAL
  []
  [k_x]
    order = CONSTANT
    family = MONOMIAL
  []
  [k_y]
    order = CONSTANT
    family = MONOMIAL
  []
  [k_z]
    order = CONSTANT
    family = MONOMIAL
  []
  [lambda]
     order = CONSTANT
     family = MONOMIAL
  []

[]

[AuxKernels]
  [thermal_cond]
     type = MaterialStdVectorAux
     variable = lambda
     property = solid_thermal_conductivity
     index = 0
     execute_on = 'INITIAL TIMESTEP_END'
  []
  [darcyx]
    type = GolemDarcyVelocity
    variable = v_x
    component = 0
    execute_on = 'INITIAL TIMESTEP_END'
  []
  [darcyy]
    type = GolemDarcyVelocity
    variable = v_y
    component = 1
    execute_on = 'INITIAL TIMESTEP_END'
  []
  [darcyz]
    type = GolemDarcyVelocity
    variable = v_z
    component = 2
    execute_on = 'INITIAL TIMESTEP_END'
  []
  [permx]
    type = MaterialStdVectorAux
    variable = k_x
    property = permeability
    index = 0
    execute_on = "INITIAL FINAL"
  []
  [permy]
    type = MaterialStdVectorAux
    variable = k_y
    property = permeability
    index = 1
    execute_on = "INITIAL FINAL"
  []
  [permz]
    type = MaterialStdVectorAux
    variable = k_z
    property = permeability
    index = 2
    execute_on = "INITIAL FINAL"
  []

[]



[Materials]
  [01_quaternary]
    type = GolemMaterialTHSUPG
    block = '0'
    porosity_initial = 0.23
    solid_thermal_conductivity_uo = lambda_quaternary
    solid_heat_rate_uo = radio_quaternary
    solid_heat_capacity_uo = c_quaternary
    solid_density_uo = rho_quaternary
    fluid_modulus = 2.18e+5
    permeability_type = orthotropic
    permeability_initial = '1e-13 1e-13 1e-14'
  []
  [02_postrupelian]
    type = GolemMaterialTHSUPG
    block = '1'
    porosity_initial = 0.23
    solid_thermal_conductivity_uo = lambda_postrupelian
    solid_heat_rate_uo = radio_postrupelian
    solid_heat_capacity_uo = c_postrupelian
    solid_density_uo = rho_postrupelian
    permeability_type = orthotropic
    permeability_uo = perm_postrupelian
  []
  [03_Rupelian]
    type = GolemMaterialTHSUPG
    block = '2'
    porosity_initial = 0.20
    solid_thermal_conductivity_uo = lambda_rupelian
    solid_heat_rate_uo = radio_rupelian
    solid_heat_capacity_uo = c_rupelian
    solid_density_uo = rho_rupelian
    permeability_type = orthotropic
    permeability_uo = perm_rupelian
  []
  [04_Prerupelian]
    type = GolemMaterialTHSUPG
    block = '3'
    porosity_initial = 0.1
    solid_thermal_conductivity_uo = lambda_prerupelian
    solid_heat_rate_uo = radio_prerupelian
    solid_heat_capacity_uo = c_prerupelian
    solid_density_uo = rho_prerupelian
    permeability_type = orthotropic
    permeability_initial = '1e-14 1e-14 1e-15'
  []
  [05_uppercretaceous]
    type = GolemMaterialTHSUPG
    block = '4'
    porosity_initial = 0.1
    solid_thermal_conductivity_uo = lambda_uppercretaceous
    solid_heat_rate_uo = radio_uppercretaceous
    solid_heat_capacity_uo = c_uppercretaceous
    solid_density_uo = rho_uppercretaceous
    permeability_type = orthotropic
    permeability_initial = '1e-13 1e-13 1e-14'
  []
  [06_lowercretaceous]
    type = GolemMaterialTHSUPG
    block = '5'
    porosity_initial = 0.13
    solid_thermal_conductivity_uo = lambda_lowercretaceous
    solid_heat_rate_uo = radio_lowercretaceous
    solid_heat_capacity_uo = c_lowercretaceous
    solid_density_uo = rho_lowercretaceous
    permeability_type = orthotropic
    permeability_initial = '1e-13 1e-13 1e-14'
  []
  [07_jurassic]
    type = GolemMaterialTHSUPG
    block = '6'
    porosity_initial = 0.13
    solid_thermal_conductivity_uo = lambda_jurassic
    solid_heat_rate_uo = radio_jurassic
    solid_heat_capacity_uo = c_jurassic
    solid_density_uo = rho_jurassic
    permeability_type = orthotropic
    permeability_initial = '1e-13 1e-13 1e-14'
  []
  [08_Keuper]
    type = GolemMaterialTHSUPG
    block = '7'
    porosity_initial = 0.06
    solid_thermal_conductivity_uo = lambda_keuper
    solid_heat_rate_uo = radio_keuper
    solid_heat_capacity_uo = c_keuper
    solid_density_uo = rho_keuper
    permeability_type = orthotropic
    permeability_initial = '1e-14 1e-14 1e-15'
  []
  [09_Muschelkalk]
    type = GolemMaterialTHSUPG
    block = '8'
    porosity_initial = 0.001
    solid_thermal_conductivity_uo = lambda_muschelkalk
    solid_heat_rate_uo = radio_muschelkalk
    solid_heat_capacity_uo = c_muschelkalk
    solid_density_uo = rho_muschelkalk
    permeability_type = orthotropic
    permeability_initial = '1e-18 1e-18 1e-19'
  []
  [10_Buntsandstein]
    type = GolemMaterialTHSUPG
    block = '9'
    porosity_initial = 0.04
    solid_thermal_conductivity_uo = lambda_buntsandstein
    solid_heat_rate_uo = radio_buntsandstein
    solid_heat_capacity_uo = c_bundsandstein
    solid_density_uo = rho_bundsandstein
    permeability_type = orthotropic
    permeability_initial = '1e-14 1e-14 1e-15'
  []
  [11_Zechstein]
    type = GolemMaterialTHSUPG
    block = '10'
    porosity_initial = 1e-5
    solid_thermal_conductivity_uo = lambda_zechstein
    solid_heat_rate_uo = radio_zechstein
    solid_heat_capacity_uo = c_zechstein
    solid_density_uo = rho_zechstein
    permeability_type = orthotropic
    permeability_initial = '1e-17 1e-17 1e-18'
  []
  [12_basement]
    type = GolemMaterialTHSUPG
    block = '11'
    porosity_initial = 1e-5
    solid_thermal_conductivity_uo = lambda_basement
    solid_heat_rate_uo = radio_basement
    solid_heat_capacity_uo = c_basement
    solid_density_uo = rho_basement
    permeability_initial = '1e-17'
  []

[]

[UserObjects]
  [scaling]
    type = GolemScaling
    characteristic_time = 31536000 #years
    # characteristic_length = 1.0
    # characteristic_temperature = 1.0
    characteristic_stress = 1e6
    execute_on = 'INITIAL'
  []
  [termination]
    type = Terminator
    expression = '(max_diff_T<0.1)&(max_diff_p<1e-2)&(max_diff_T>0.0)&(max_diff_p>0.0)'
    fail_mode = HARD
    execute_on = 'TIMESTEP_END'
  []
  [supg]
    type = GolemSUPG
    execute_on = 'INITIAL'
  []
  [porosity]
    type = GolemPorosityConstant
    execute_on = 'INITIAL'
  []
  [fluid_density]
    type = GolemFluidDensityConstant
    execute_on = 'INITIAL'
  []
  [fluid_viscosity]
    type = GolemFluidViscosityConstant
    execute_on = 'INITIAL'
  []
  [permeability]
    type = GolemPermeabilityConstant
    execute_on = 'INITIAL'
  []

  [perm_postrupelian]
    type = GolemPermeabilityInterpolation
    dimension = 3
    tensor_type = orthotropic
    sample_file_name = 'prop/postrupelian_permeability.csv'
    interpolation_type = max_neighbours
    patch_size = 4
    max_leaf = 10
    epsilon = 1e-10
    execute_on = 'INITIAL'
  []
  [perm_rupelian]
    type = GolemPermeabilityInterpolation
    dimension = 3
    tensor_type = orthotropic
    sample_file_name = 'prop/rupelian_permeability.csv'
    interpolation_type = max_neighbours
    patch_size = 4
    max_leaf = 10
    epsilon = 1e-10
    execute_on = 'INITIAL'
  []
  [lambda_f]
    type = GolemFluidThermalConductivityConstant
    value = 0.65
    execute_on = 'INITIAL'
  []
  [cp_f]
    type = GolemFluidHeatCapacityConstant
    value = 4.18e+03
    execute_on = 'INITIAL'
  []
  [c_quaternary]
    type = GolemSolidHeatCapacityConstant
    value = 1620
    execute_on = 'INITIAL'
  []
  [c_postrupelian]
    type = GolemSolidHeatCapacityConstant
    value = 1640
    execute_on = 'INITIAL'
  []
  [c_rupelian]
    type = GolemSolidHeatCapacityConstant
    value = 1810
    execute_on = 'INITIAL'
  []
  [c_prerupelian]
    type = GolemSolidHeatCapacityConstant
    value = 1700
    execute_on = 'INITIAL'
  []
  [c_uppercretaceous]
    type = GolemSolidHeatCapacityConstant
    value = 2290
    execute_on = 'INITIAL'
  []
  [c_lowercretaceous]
    type = GolemSolidHeatCapacityConstant
    value = 2290
    execute_on = 'INITIAL'
  []
  [c_jurassic]
    type = GolemSolidHeatCapacityConstant
    value = 2250
    execute_on = 'INITIAL'
  []
  [c_keuper]
    type = GolemSolidHeatCapacityConstant
    value = 2320
    execute_on = 'INITIAL'
  []
  [c_muschelkalk]
    type = GolemSolidHeatCapacityConstant
    value = 2250
    execute_on = 'INITIAL'
  []
  [c_bundsandstein]
    type = GolemSolidHeatCapacityConstant
    value = 2390
    execute_on = 'INITIAL'
  []
  [c_zechstein]
    type = GolemSolidHeatCapacityConstant
    value = 1940
    execute_on = 'INITIAL'
  []
  [c_basement]
    type = GolemSolidHeatCapacityConstant
    value = 2600
    execute_on = 'INITIAL'
  []
  [rho_quaternary]
    type = GolemSolidDensityConstant
    value = 2100
    execute_on = 'INITIAL'
  []
  [rho_postrupelian]
    type = GolemSolidDensityConstant
    value = 2100
    execute_on = 'INITIAL'
  []
  [rho_rupelian]
    type = GolemSolidDensityConstant
    value = 2400
    execute_on = 'INITIAL'
  []
  [rho_prerupelian]
    type = GolemSolidDensityConstant
    value = 2100
    execute_on = 'INITIAL'
  []
  [rho_uppercretaceous]
    type = GolemSolidDensityConstant
    value = 2215
    execute_on = 'INITIAL'
  []
  [rho_lowercretaceous]
    type = GolemSolidDensityConstant
    value = 2215
    execute_on = 'INITIAL'
  []
  [rho_jurassic]
    type = GolemSolidDensityConstant
    value = 2450
    execute_on = 'INITIAL'
  []
  [rho_keuper]
    type = GolemSolidDensityConstant
    value = 2530
    execute_on = 'INITIAL'
  []
  [rho_muschelkalk]
    type = GolemSolidDensityConstant
    value = 2530
    execute_on = 'INITIAL'
  []
  [rho_bundsandstein]
    type = GolemSolidDensityConstant
    value = 2530
    execute_on = 'INITIAL'
  []
  [rho_zechstein]
    type = GolemSolidDensityConstant
    value = 2150
    execute_on = 'INITIAL'
  []
  [rho_basement]
    type = GolemSolidDensityConstant
    value = 2600
    execute_on = 'INITIAL'
  []

  [lambda_quaternary]
    type = GolemSolidThermalConductivityConstant
    value = 1.5
    execute_on = 'INITIAL'
  []
  [lambda_postrupelian]
    type = GolemSolidThermalConductivityConstant
    value = 1.5
    execute_on = 'INITIAL'
  []
  [lambda_rupelian]
    type = GolemSolidThermalConductivityConstant
    value = 1
    execute_on = 'INITIAL'
  []
  [lambda_prerupelian]
    type = GolemSolidThermalConductivityConstant
    value = 1.9
    execute_on = 'INITIAL'
  []
  [lambda_uppercretaceous]
    type = GolemSolidThermalConductivityConstant
    value = 1.9
    execute_on = 'INITIAL'
  []
  [lambda_lowercretaceous]
    type = GolemSolidThermalConductivityConstant
    value = 2
    execute_on = 'INITIAL'
  []
  [lambda_jurassic]
    type = GolemSolidThermalConductivityConstant
    value = 2
    execute_on = 'INITIAL'
  []
  [lambda_keuper]
    type = GolemSolidThermalConductivityConstant
    value = 2.3
    execute_on = 'INITIAL'
  []
  [lambda_muschelkalk]
    type = GolemSolidThermalConductivityConstant
    value = 1.85
    execute_on = 'INITIAL'
  []
  [lambda_buntsandstein]
    type = GolemSolidThermalConductivityConstant
    value = 2
    execute_on = 'INITIAL'
  []
  [lambda_zechstein]
    type = GolemSolidThermalConductivityConstant
    value = 3.5
    execute_on = 'INITIAL'
  []
  [lambda_basement]
    type = GolemSolidThermalConductivityConstant
    value = 2.5
    execute_on = 'INITIAL'
  []

  [radio_quaternary]
    type = GolemSolidHeatRateConstant
    value = 7e-7
    execute_on = 'INITIAL'
  []
  [radio_postrupelian]
    type = GolemSolidHeatRateConstant
    value = 7e-7
    execute_on = 'INITIAL'
  []
  [radio_rupelian]
    type = GolemSolidHeatRateConstant
    value = 4.5e-7
    execute_on = 'INITIAL'
  []
  [radio_prerupelian]
    type = GolemSolidHeatRateConstant
    value = 3e-7
    execute_on = 'INITIAL'
  []
  [radio_uppercretaceous]
    type = GolemSolidHeatRateConstant
    value = 3e-7
    execute_on = 'INITIAL'
  []
  [radio_lowercretaceous]
    type = GolemSolidHeatRateConstant
    value = 1.4e-6
    execute_on = 'INITIAL'
  []
  [radio_jurassic]
    type = GolemSolidHeatRateConstant
    value = 1.4e-6
    execute_on = 'INITIAL'
  []
  [radio_keuper]
    type = GolemSolidHeatRateConstant
    value = 1.4e-6
    execute_on = 'INITIAL'
  []
  [radio_muschelkalk]
    type = GolemSolidHeatRateConstant
    value = 3e-7
    execute_on = 'INITIAL'
  []
  [radio_buntsandstein]
    type = GolemSolidHeatRateConstant
    value = 1e-6
    execute_on = 'INITIAL'
  []
  [radio_zechstein]
    type = GolemSolidHeatRateConstant
    value = 9e-8
    execute_on = 'INITIAL'
  []
  [radio_basement]
    type = GolemSolidHeatRateConstant
    value = 1.5e-6
    execute_on = 'INITIAL'
  []

[]

[Preconditioning]
  active = 'FSP'
  [FSP]
    type = FSP
    topsplit = 'HT'
    [HT]
      splitting = 'H T'
      splitting_type = multiplicative
      petsc_options = '-snes_ksp -snes_converged_reason'
      petsc_options_iname = '-snes_force_iteration
                              -snes_type -snes_linesearch_type
                             -snes_atol -snes_rtol -snes_max_it
                             -ksp_type
                             -ksp_atol -ksp_rtol -ksp_max_it'
      petsc_options_value = '1
                             newtonls basic
                             1e-3 1e-12 100
                             fgmres
                             2e-3 1e-8 25'
    []
    [H]
      vars = 'pore_pressure'
      petsc_options_iname = '-snes_force_iteration -ksp_type
                             -pc_type -pc_hypre_type
                             -ksp_rtol -ksp_max_it -ksp_atol'
      petsc_options_value = '1 preonly
                             hypre boomeramg
                             1e-4 100 1e-6'
    []
    [T]
      vars = 'temperature'
      petsc_options_iname = '-snes_force_iteration -ksp_type
                             -pc_type -pc_hypre_type
                             -ksp_rtol -ksp_max_it -ksp_atol'
      petsc_options_value = '1 gcr
                             hypre boomeramg
                             1e-4 100 1e-3'
    []
  []
[]

[Postprocessors]
  # maximum diff in temperature between a time step
  [max_diff_T]
    type = GolemNodalMaxDifValue
    variable = temperature
  []
  # maximum diff in pore_pressure between a time step
  [max_diff_p]
    type = GolemNodalMaxDifValue
    variable = pore_pressure
  []
  [vx_pp]
    type = ElementExtremeValue
    variable = v_x
    outputs = 'console'
  []
  [vy_pp]
    type = ElementExtremeValue
    variable = v_y
    outputs = 'console'
  []
  [vz_pp]
    type = ElementExtremeValue
    variable = v_z
    outputs = 'console'
  []
[]

[MultiApps]
  [sub_temp]
    type = FullSolveMultiApp
    input_files = 'ic_T_lubc.i'
    execute_on = 'INITIAL'
  []
  [sub_pf]
    type = FullSolveMultiApp
    input_files = 'ic_H_upbc.i'
    execute_on = 'INITIAL'
  []
[]

[Transfers]
  [temp_from_sub]
    type = MultiAppCopyTransfer
    variable = temperature
    source_variable = temperature
    from_multi_app = sub_temp
  []
  [pf_from_sub]
    type = MultiAppCopyTransfer
    variable = pore_pressure
    source_variable = pore_pressure
    from_multi_app = sub_pf
  []
[]

[Executioner]
  type = Transient
  steady_state_start_time = 1e6
  #how does this ss start impact simulation?
  steady_state_detection = true
  steady_state_tolerance = 1e-8
  solve_type = NEWTON
  start_time = 0
  end_time = 1e6
  dt = 500
  automatic_scaling = true
  compute_scaling_once = false
[]

[Outputs]
  print_linear_residuals = false
  perf_graph = true

  [exo]
    type = Exodus
    execute_on = 'INITIAL TIMESTEP_END FINAL'

  []

[]
