#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""

@author: jcgomez
"""
import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt

BtoA_conv_matrix = pd.read_csv('CM_Medina_2019_M-MP_to_SARA_MUR-H1-3.csv') #change to any file
#BtoA_conv_matrix = pd.read_csv('CM_Medina_2019_M-PN_to_SARA_W-WLI-H1-3.csv') #change to any file
BtoA_conv_matrix = pd.read_csv('CM_Medina_2019_M-PCP3_to_SARA_CR-LDUAL-DUC-H4-7.csv') #change to any file

del BtoA_conv_matrix['Unnamed: 0']

sns.set(font_scale=1.3)
cmap = sns.diverging_palette(220, 20, sep=20, as_cmap=True)
cmap = 'viridis'
fontsize_pt = 10
dpi = 72.27


fig, ax = plt.subplots(
        figsize=(5,4)) 

ax = sns.heatmap(BtoA_conv_matrix, ax=ax, cmap=cmap, yticklabels=['$D_0$','$D_1$','$D_2$','$D_3$','$D_4$'], xticklabels=['$D_0$','$D_1$','$D_2$','$D_3$','$D_4$'], vmin=0, vmax=1) 
#plt.xlabel('$EQ_{SARA}$:  W-WLI-H1-3',fontsize= '16',fontweight="bold", y=0.5, labelpad=10 )
#plt.ylabel('$EQ_{SARA}$:  W-WS-H1-2',fontsize= '16',fontweight="bold", y=0.5, labelpad=10 )
#plt.xlabel('$EQ_{SARA}$:  MUR-ADO-H1-2',fontsize= '16',fontweight="bold", y=0.5, labelpad=10 )
plt.xlabel('$EQ_{SARA}$:  CR-LDUAL-DUC-H4-7',fontsize= '16',fontweight="bold", y=0.5, labelpad=10 )
#plt.ylabel('$TS_{Medina}$:  M-MP',fontsize= '16',fontweight="bold", y=0.5, labelpad=10)
#plt.ylabel('$TS_{Medina}$:  M-PN',fontsize= '16',fontweight="bold", y=0.5, labelpad=10)
plt.ylabel('$TS_{Medina}$:  M-PCP3',fontsize= '16',fontweight="bold", y=0.5, labelpad=10)
plt.xticks(fontsize=18, rotation=0)
plt.yticks(fontsize=18, rotation=0)
plt.show()