#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""

@author: jcgomez
"""

import pandas as pd
import numpy as np
import warnings; warnings.filterwarnings("ignore")
import matplotlib.pyplot as plt

x1= pd.read_csv('Medina_2019_M-PN_to_SARA_v1.0_W-WLI-H1-3.csv')

x1 = x1[(x1['4']<0.999)]
x1 = x1[(x1['3']<=0.999)]
x1 = x1[(x1['2']<=0.999)]

x= np.array(x1['DMS_VS'])
y=np.array(x1['DMS_RF'])
ds1=np.array([x1['1']])
ds2= np.array([x1['2']])
ds3=np.array([x1['3']])
ds4= np.array([x1['4']])

fig=plt.figure(figsize=(15,15))
fig.suptitle('(a) MUR-ADO-H1-2', fontsize=16, fontweight="bold", y=0.63)
#===============
#  First subplot
#===============
# set up the axes for the first plot
ax1 = fig.add_subplot(1, 4, 1, projection='3d')
plt.title("D1= Slight", fontsize=15, fontweight="bold", y=1.05 )
ax1.scatter(x,y,ds1,  c=ds1, cmap='nipy_spectral', linewidth=0.5, s=40)
ax1.set_zlim(0, 1)
ax1.set_ylim(9, 0) 
ax1.set_zlabel('$\Prob.$', fontsize=15, rotation = 0)
ax1.set_ylabel('$OD_{AeDES}(RF)$', fontsize=15)
ax1.set_xlabel('$OD_{AeDES}(VS)$', fontsize=15)  
ax1 = fig.add_subplot(1, 4, 2, projection='3d')
plt.title("D2= Moderate", fontsize=15, fontweight="bold", y=1.05 )
ax1.set_ylim(9, 0) 
ax1.scatter(x,y,ds2, c=ds2, cmap='nipy_spectral', linewidth=0.5, s=40)
ax1.invert_yaxis()
ax1.set_zlabel('$\Prob.$', fontsize=15, rotation = 0)
ax1.set_ylabel('$OD_{AeDES}(RF)$', fontsize=15)
ax1.set_xlabel('$OD_{AeDES}(VS)$', fontsize=15)  
ax1.set_zlim(0, 1)
ax1 = fig.add_subplot(1, 4, 3, projection='3d')
plt.title("D3= Extensive", fontsize=15, fontweight="bold", y=1.05 )
ax1.set_ylim(9, 0) 
ax1.scatter(x,y,ds3, c=ds3, cmap='nipy_spectral', linewidth=0.5, s=40)
ax1.set_zlabel('$\Prob.$', fontsize=15, rotation = 0)
ax1.set_ylabel('$OD_{AeDES}(RF)$', fontsize=15)
ax1.set_xlabel('$OD_{AeDES}(VS)$', fontsize=15)  
ax1.set_zlim(0, 1)
ax1 = fig.add_subplot(1,4, 4, projection='3d')
plt.title("D4 = Collapse", fontsize=15, fontweight="bold", y=1.05 )
ax1.set_ylim(9, 0) 
p=ax1.scatter(x,y,ds4, c=ds4, cmap='nipy_spectral', linewidth=0.5, s=40)
ax1.set_ylabel('$OD_{AeDES}(RF)$', fontsize=15)
ax1.set_xlabel('$OD_{AeDES}(VS)$', fontsize=15)  
ax1.set_zlim(0, 1)
ax1.set_zlabel('$\Prob.$', fontsize=15, rotation = 0)
fig.get_size_inches()
ax1.set_aspect('auto')
cb_ax = fig.add_axes([0.95, 0.43, 0.02, 0.14])
cbar = fig.colorbar(p, cax=cb_ax)

plt.show()
plt.tight_layout(h_pad=1)